﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="MyRisks.ascx.cs" Inherits="GUI.Pages.DashboardControls.MyRisks" %>
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
<telerik:RadGrid ID="grdList" GroupingSettings-CaseSensitive="false" runat="server" PageSize="5" AllowFilteringByColumn="true" CssClass="kendo-table" Skin="Bootstrap"
    OnItemCommand="grdList_OnItemCommand" OnItemDataBound="grdList_ItemDataBound" AllowPaging="true" AllowSorting="true"
    OnNeedDataSource="grdList_OnNeedDataSource" OnColumnCreating="grdList_OnColumnCreating">
    <PagerStyle Mode="NextPrevAndNumeric" />
    <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" CssClass="table table-striped table-hover" ShowFooter="False"
        AutoGenerateColumns="False" DataKeyNames="Id">

        <CommandItemTemplate>

            <asp:Literal ID="Literal1" runat="server"></asp:Literal>

        </CommandItemTemplate>

        <Columns>            
            <telerik:GridBoundColumn UniqueName="RiskNameColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                SortExpression="RiskName" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name">
                
                <HeaderStyle Width="25%" /> 

            </telerik:GridBoundColumn>
            
            <telerik:GridBoundColumn UniqueName="ProjectColumn" HeaderStyle-Width="150" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="ProjectName" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Project %>" DataField="Project.Name">

                <HeaderStyle Width="25%" /> 

            </telerik:GridBoundColumn>
			
            <telerik:GridBoundColumn UniqueName="ActivitiesDisplayString" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="ActivitiesDisplayString" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Activity %>" DataField="ActivitiesDisplayString">
                <HeaderStyle Width="25%" /> 

            </telerik:GridBoundColumn>

            <telerik:GridBoundColumn UniqueName="ResolveUntil" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="ResolveUntil" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Task_ResolveUntil %>" DataField="ResolveUntil" DataFormatString="{0:d/M/yyyy}">

                <HeaderStyle Width="15%" />

            </telerik:GridBoundColumn>
		
            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="95" HeaderText="<%$ Resources:ProjectManagementUI, UI_Finished %>" UniqueName="IsClosed" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="Progress" >
				<ItemTemplate>
                     <i class="fa fa-1x fa-<%# (Eval("IsClosed").ToString() == "True") ? "check-square font-kendo-green" : "check-square font-kendo-red" %>"></i>  
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>

            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="100" HeaderText="<%$ Resources:ProjectManagementUI, Common_Influence %>" UniqueName="IconName" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="IconName" >
				<ItemTemplate>
                     <i class="fa fa-arrow-circle-<%#(Eval("IconName").ToString() == "Medium" ? "right font-kendo-yellow" : "")%><%#(Eval("IconName").ToString() == "High" ? "up font-kendo-red" : "")%><%#(Eval("IconName").ToString() == "Low" ? "down font-kendo-green" : "")%>"></i>
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
			
				<telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="40">
				<ItemTemplate>
					<a class="btn btn-xs btn-primary font-white" href="<%= getVirtualPath() %>/Pages/ProjectRisk.aspx?fromDashboard=true&riskId=<%# Eval("Id") %>"><i class="fa fa-edit"></i></a>
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
        </Columns>
    </MasterTableView>
</telerik:RadGrid>
</telerik:RadAjaxPanel>
<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
        <div class="updatePanelProgress">
            <asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>